/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.cadgeometry;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProductStructureChildNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLShapeNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public class BaseCADFace
extends AbstractNode
implements VRMLProductStructureChildNodeType {
    private static final int[] SECONDARY_TYPE = new int[0];
    protected static final int FIELD_NAME = 1;
    protected static final int FIELD_SHAPE = 2;
    protected static final int FIELD_BBOX_CENTER = 3;
    protected static final int FIELD_BBOX_SIZE = 4;
    protected static final int LAST_CADFACE_INDEX = 4;
    protected static final int NUM_FIELDS = 5;
    protected static final String SHAPE_PROTO_MSG = "Proto does not describe a Shape object";
    protected static final String SHAPE_NODE_MSG = "Node does not describe a Shape object";
    protected static final VRMLFieldDeclaration[] fieldDecl;
    protected static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected String vfName;
    protected VRMLNodeType vfShape;
    protected VRMLProtoInstance pShape;
    protected float[] vfBboxCenter;
    protected float[] vfBboxSize = new float[]{-1.0f, -1.0f, -1.0f};

    public BaseCADFace() {
        super("CADFace");
        this.vfBboxCenter = new float[]{0.0f, 0.0f, 0.0f};
        this.hasChanged = new boolean[5];
    }

    public BaseCADFace(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("name");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfName = vRMLFieldData.stringValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setName(String string) {
        this.vfName = string;
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public String getName() {
        return this.vfName;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pShape != null) {
            this.pShape.setupFinished();
        }
        if (this.vfShape != null) {
            this.vfShape.setupFinished();
        }
    }

    public int getPrimaryType() {
        return 76;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 4) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)6;
                vRMLFieldData.stringValue = this.vfName;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pShape != null ? this.pShape : this.vfShape;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBboxSize;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBboxCenter;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfName);
                    break;
                }
                case 2: {
                    if (this.pShape != null) {
                        vRMLNodeType.setValue(n2, this.pShape);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfShape);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 2: {
                this.setShape(vRMLNodeType2);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
        if (!this.inSetup) {
            this.hasChanged[n] = true;
            this.fireFieldChanged(n);
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.vfName = string;
                if (this.inSetup) break;
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 3: {
                this.setBboxCenter(fArray);
                break;
            }
            case 4: {
                this.setBboxSize(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    protected void setShape(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLShapeNodeType vRMLShapeNodeType;
        VRMLNodeType vRMLNodeType2 = this.pShape != null ? this.pShape : this.vfShape;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLShapeNodeType = (VRMLShapeNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pShape = (VRMLProtoInstance)vRMLNodeType;
            if (vRMLShapeNodeType != null && !(vRMLShapeNodeType instanceof VRMLShapeNodeType)) {
                throw new InvalidFieldValueException(SHAPE_PROTO_MSG);
            }
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLShapeNodeType)) {
                throw new InvalidFieldValueException(SHAPE_NODE_MSG);
            }
            this.pShape = null;
            vRMLShapeNodeType = (VRMLShapeNodeType)vRMLNodeType;
        }
        this.vfShape = vRMLShapeNodeType;
        if (!this.inSetup) {
            if (vRMLNodeType2 != null) {
                this.updateRefs(vRMLNodeType2, false);
                this.stateManager.registerRemovedNode(vRMLNodeType2);
            }
            if (vRMLNodeType != null) {
                this.updateRefs(vRMLNodeType, true);
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    protected void setBboxCenter(float[] fArray) {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field:  bboxCenter");
        }
        this.vfBboxCenter[0] = fArray[0];
        this.vfBboxCenter[1] = fArray[1];
        this.vfBboxCenter[2] = fArray[2];
    }

    protected void setBboxSize(float[] fArray) throws InvalidFieldValueException {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field:  bboxSize");
        }
        this.vfBboxSize[0] = fArray[0];
        this.vfBboxSize[1] = fArray[1];
        this.vfBboxSize[2] = fArray[2];
    }

    static {
        nodeFields = new int[]{2, 0};
        fieldDecl = new VRMLFieldDeclaration[5];
        fieldMap = new HashMap(5);
        BaseCADFace.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseCADFace.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "shape");
        BaseCADFace.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFString", "name");
        BaseCADFace.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseCADFace.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(2);
        fieldMap.put("shape", n);
        fieldMap.put("set_shape", n);
        fieldMap.put("shape_changed", n);
        n = new Integer(1);
        fieldMap.put("name", n);
        fieldMap.put("set_name", n);
        fieldMap.put("name_changed", n);
        fieldMap.put("bboxCenter", new Integer(3));
        fieldMap.put("bboxSize", new Integer(4));
    }
}

